/*
 * Decompiled with CFR 0.152.
 */
package net.jayjay.dangerzone.block;

import java.util.HashMap;
import java.util.Map;
import net.jayjay.dangerzone.block.Block;
import net.jayjay.dangerzone.block.BlockAir;
import net.jayjay.dangerzone.block.BlockBedrock;
import net.jayjay.dangerzone.block.BlockBoxOBlood;
import net.jayjay.dangerzone.block.BlockCloud;
import net.jayjay.dangerzone.block.BlockDirt;
import net.jayjay.dangerzone.block.BlockDynamite;
import net.jayjay.dangerzone.block.BlockGlass;
import net.jayjay.dangerzone.block.BlockGrass;
import net.jayjay.dangerzone.block.BlockLeaves;
import net.jayjay.dangerzone.block.BlockLog;
import net.jayjay.dangerzone.block.BlockOakSapling;
import net.jayjay.dangerzone.block.BlockPlant;
import net.jayjay.dangerzone.block.BlockSand;
import net.jayjay.dangerzone.block.BlockSpike;
import net.jayjay.dangerzone.block.BlockStone;
import net.jayjay.dangerzone.block.BlockSuperSapling;
import net.jayjay.dangerzone.block.BlockWater;

public class Blocks {
    private static final Map<String, Block> blockRegistry = new HashMap<String, Block>();
    private static final Map<String, Integer> tagToId = new HashMap<String, Integer>();
    public static int nextId = 0;
    public static int blockLimit = -1;
    public static final int maxBlocks = 4096;
    public static Block[] blocks = new Block[4096];
    public static final Block empty = null;
    public static final Block air = new BlockAir("dz2:air");
    public static final Block stone = new BlockStone("dz2:stone", 1);
    public static final Block grass = new BlockGrass("dz2:grass");
    public static final Block dirt = new BlockDirt("dz2:dirt", 2);
    public static final Block cobbleStone = new Block("dz2:cobblestone", 16);
    public static final Block oakPlanks = new Block("dz2:oak_planks", 4);
    public static final Block oakSapling = new BlockOakSapling("dz2:oak_sapling", 15);
    public static final Block bedrock = new BlockBedrock("dz2:bedrock", 17);
    public static final Block water = new BlockWater("dz2:water", 13);
    public static final Block bloodBox = new BlockBoxOBlood("dz2:dork_cube");
    public static final Block bricks = new Block("dz2:bricks", 7);
    public static final Block iron = new Block("dz2:iron_block", 18);
    public static final Block copper = new Block("dz2:copper_block", 19);
    public static final Block glass = new BlockGlass("dz2:glass", 20);
    public static final Block sand = new BlockSand("dz2:sand", 8);
    public static final Block gravel = new BlockSand("dz2:gravel", 9);
    public static final Block stoneBrick = new Block("dz2:stone_bricks", 10);
    public static final Block oakLog = new BlockLog("dz2:oak_log", 12, 11);
    public static final Block deadSapling = new BlockPlant("dz2:dead_sapling", 31);
    public static final Block mese = new Block("dz2:mese_block", 21);
    public static final Block ruby = new Block("dz2:ruby_block", 22);
    public static final Block blerik = new Block("dz2:blerik", 23);
    public static final Block dynamite = new BlockDynamite("dz2:dynamite_block", 24, 10.0f);
    public static final Block oakLeaves = new BlockLeaves("dz2:oak_leaves", 25);
    public static final Block tallGrass = new BlockPlant("dz2:tall_grass", 47);
    public static final Block rose = new BlockPlant("dz2:rose", 63);
    public static final Block cloud = new BlockCloud("dz2:cloud_block", 26);
    public static final Block copperOre = new BlockStone("dz2:copper_ore", 32);
    public static final Block ironOre = new BlockStone("dz2:iron_ore", 33);
    public static final Block blueRose = new BlockPlant("dz2:blue_rose", 79);
    public static final Block superLog = new BlockLog("dz2:super_log", 28, 27);
    public static final Block superLeaves = new BlockLeaves("dz2:super_leaves", 29);
    public static final Block nuke = new BlockDynamite("dz2:nuke", 30, 100.0f);
    public static final Block meseOre = new BlockStone("dz2:mese_ore", 34);
    public static final Block dandelion = new BlockPlant("dz2:dandelion", 95);
    public static final Block rubyOre = new BlockStone("dz2:ruby_ore", 35);
    public static final Block superSapling = new BlockSuperSapling("dz2:super_sapling", 111);
    public static final Block stoneSpike = new BlockSpike("dz2:stone_spike", 1);

    public static void registerBlock(Block block) {
        blockRegistry.put(block.blockTag, block);
        tagToId.put(block.blockTag, nextId);
        Blocks.blocks[Blocks.nextId] = block;
        ++nextId;
    }

    public static void registerBlock(Block block, String tag) {
        blockRegistry.put(tag, block);
        tagToId.put(tag, nextId);
        Blocks.blocks[Blocks.nextId] = block;
        ++nextId;
    }

    public static Block getBlock(String tag) {
        return blockRegistry.get(tag);
    }

    public static int getBlockID(String tag) {
        return tagToId.getOrDefault(tag, -1);
    }

    public static Block getBlockById(int id) {
        if (id >= 0 && id < blocks.length) {
            return blocks[id];
        }
        return null;
    }
}

